<?php
// *****************************************************************************
// Copyright 2003-2005 by A J Marston <http://www.tonymarston.net>
// Copyright 2006-2023 by Radicore Software Limited <http://www.radicore.org>
// *****************************************************************************
// $Date: 2024-09-21 15:29:21 +0100 (Sat, 21 Sep 2024) $
// $Author: tony $
// $Revision: 1577 $
// *****************************************************************************

// this contains the default processing for control records on the MNU_CONTROL table

require_once 'std.table.class.inc';
class std_control_record extends Default_Table
{
    // extra variables
    var $record_id=null;        // identifies this subsystem

    var $changes=array();

    // ****************************************************************************
    // class constructor
    // ****************************************************************************
    function __construct ()
    {
        // save directory name of current script
        $this->dirname      = $_SERVER['DOCUMENT_ROOT'].dirname($_SERVER['PHP_SELF']).'/classes';

        $this->dirname_dict = $_SERVER['DOCUMENT_ROOT'].dirname(dirname($_SERVER['PHP_SELF'])).'/menu/classes';

        $this->tablename    = 'mnu_control';
        $this->dbname       = 'menu';

        // call this method to get original field specifications
        // (note that they may be modified at runtime)
        $this->fieldspec = $this->loadFieldSpec();

    } // __construct

    // ****************************************************************************
    function _cm_changeConfig ($where, $fieldarray)
    // Change the table configuration for the duration of this instance.
    // $where = a string in SQL 'where' format.
    // $fieldarray = the contents of $where as an array.
    {
        // define these so that $where does not get filtered out
        $fieldspec['record_id'] = array('type' => 'string');
        $fieldspec['field_id']  = array('type' => 'string');

        // ********************************************************************
        // define all columns here
        // ********************************************************************

        //$fieldspec['xxx']                   = array('type' => 'string',
        //                                            'required' => 'y',
        //                                            'size' => '10');

        $this->fieldspec = $fieldspec;

        if (is_object($this->custom_processing_object)) {
            if (method_exists($this->custom_processing_object, '_cm_changeConfig')) {
                $fieldarray = $this->custom_processing_object->_cm_changeConfig($where, $fieldarray);
                $this->errors = array_merge($this->errors, $this->custom_processing_object->getErrors());
            } // if
        } // if

        return $fieldarray;

    } // _cm_changeConfig

    // ****************************************************************************
    function _cm_commonValidation ($fieldarray, $originaldata)
    // perform validation that is common to INSERT and UPDATE.
    {
        // custom code goes here

        return $fieldarray;

    } // _cm_commonValidation

    // ****************************************************************************
    function _cm_filterWhere ($array=null)
    // identify field names which are NOT to be filtered out of a $where string.
    {
        $this->fieldspec['record_id']       = array('type' => 'string',
                                                    'size' => 16);
        $this->fieldspec['field_id']        = array('type' => 'string',
                                                    'size' => 16);
        return $array;

    } // _cm_filterWhere

    // ****************************************************************************
    function _cm_initialise ($where, &$selection, $search)
    // perform any initialisation for the current task.
    {
        if (empty($this->record_id)) {
            $this->errors = "Value for RECORD_ID has not been defined";
            return $where;
        } // if

        $where = "record_id='$this->record_id'";

        return $where;

    } // _cm_initialise

    // ****************************************************************************
    function _cm_post_getData ($rowdata, &$where)
    // perform custom processing after database record(s) are retrieved.
    // NOTE: $where is passed BY REFERENCE so that it may be modified.
    {
        $fieldarray[0] = array();

        // turn multiple rows into a single associative array
        foreach ($rowdata as $row => $data) {
            if (isset($data['field_id'])) {
                $fieldarray[0][strtolower($data['field_id'])] = $data['field_value'];
            } // if
        } // foreach

        // get list of (virtual) fields in this table
        $fieldspec = $this->getFieldSpec();
        unset($fieldspec['record_id']);  // this is not a virtual field
        unset($fieldspec['field_id']);   // this is not a virtual field

        $where_array = where2array($where);

        if (!empty($where_array['field_id'])) {
            do {
                list($name, $operator, $value) = splitNameOperatorValue($where);
                if ($name == 'field_id' AND $operator == '=') {
                    // only a single field was specified, so create a null value if not found
                    $fieldname = strtolower($value);
                    $fieldname = trim($fieldname, "'");  // trim any single quotes
                    if (!array_key_exists($fieldname, $fieldarray[0])) {
                        $fieldarray[0][$fieldname] = null;
                    } // if
                } // if
            } while (!empty($where));
        } else {
            // insert any missing fields from $fieldspec
            foreach ($fieldspec as $fieldname => $spec) {
                if (empty($fieldarray[0][$fieldname])) {
                    if (!empty($spec['default'])) {
                        $fieldarray[0][$fieldname] = $spec['default'];
                    } else {
                        $fieldarray[0][$fieldname] = null;
                    } // if
                } // if
            } // foreach
        } // if

        if (empty($fieldarray[0])) {
            return array();
        } // if

        return $fieldarray;

    } // _cm_post_getData

    // ****************************************************************************
    function _cm_post_updateRecord ($fieldarray, $old_data)
    // perform custom processing after database record is updated.
    {
        // custom code goes here

        return $fieldarray;

    } // _cm_post_updateRecord

    // ****************************************************************************
    function _cm_post_updateSelection ($selection, $replace)
    // allow changes to be made after _cm_updateSelection method has been called.
    {
        if (empty($this->changes)) {
            return $selection;
        } // if

        if (!empty($this->errors)) {
            return $selection;
        } // if

        if (array_key_exists('prev_authentication', $this->fieldarray)) {
            // replace this value in case it has been changed
            $selection['prev_authentication'] = $this->fieldarray['prev_authentication'];
        } // if

        if ($this->record_id = 'SYSTEM' AND isset($this->changes['pswd_encrypt'])) {
            // encryption has been switched, so open up a dialog with the user class
            if (empty($this->changes['authentication'])) {
                $this->changes['authentication'] = $this->fieldarray['authentication'];
            } // if
            if (empty($this->changes['pswd_cipher_method'])) {
                $this->changes['pswd_cipher_method'] = $this->fieldarray['pswd_cipher_method'];
            } // if
            $dbobject = RDCsingleton::getInstance('mnu_user');
            $dbobject->audit_logging = FALSE;
            if (!empty($this->changes['pswd_cipher_method'])) {
                $dbobject->cipher_method = $this->changes['pswd_cipher_method'];
            } // if
            // encrypt or decrypt all user passwords as required
            $errors = $dbobject->switchPasswords($this->changes['pswd_encrypt'], $this->changes['authentication']);
            if ($dbobject->errors) {
                $this->errors['pswd_encrypt'] = $dbobject->errors['user_password'];
                unset($dbobject->errors['user_password']);
                $this->errors = array_merge($this->errors, $dbobject->errors);
                return;
            } // if
        } // if

        return $selection;

    } // _cm_post_updateSelection

    // ****************************************************************************
    function _cm_pre_getData ($where, $where_array, $parent_data)
    // perform custom processing before database record(s) are retrieved.
    // (WHERE is supplied in two formats - string and array)
    // $parent_data may contain contents of current record in the parent object.
    {
        // ensure that any 'field IN (...)' statements are not converted to 'field=(...)'
        $where_array = where2array($where,null,false);

        if (empty($where_array['record_id'])) {
        	$where_array['record_id'] = $this->record_id;
        } // if

        // ensure all values are in upper case
        foreach ($where_array as $field => $value) {
        	$where_array[$field] = strtoupper($value);
        } // foreach

        $where = array2where($where_array);

        return $where;

    } // _cm_pre_getData

    // ****************************************************************************
    function _cm_updateSelection ($fieldarray, $replace)
    // update multiple rows in a single operation.
    {
        if (is_long(key($fieldarray))) {
            $fieldarray = $fieldarray[0];  // use first row only
        } // if
        $this->fieldarray = $fieldarray;

        // perform standard declarative checks on input data
        $updatearray = $this->_validateUpdatePrimary($fieldarray);
        if (!empty($this->errors)) {
            // replace any empty fields with their default values
            $this->fieldarray = array_update_empty ($fieldarray, $updatearray, false, $this->fieldspec);
            return;
        } // if

        // these fields are identifiers, and should not be written out
        unset($updatearray['record_id']);
        unset($updatearray['field_id']);

        // switch to correct directory for retrieving message text
        $GLOBALS['classdir'] = getcwd();

        $originaldata = $this->getData(null);  // fetch original data from the database
        $originaldata = $originaldata[0];      // there is only one row

        // perform any custom validation/processing before update
        $updatearray = $this->_cm_commonValidation($updatearray, $originaldata);
        if (!empty($this->errors)) {
            // replace any old fields with their new values
            $changes = getChanges($updatearray, $originaldata);
            $this->fieldarray = array_merge($fieldarray, $changes);
            return;
        } // if

        $this->changes = getChanges($updatearray, $originaldata);

        // now set $fieldspec to the database view
        $this->fieldspec = $this->loadFieldSpec();

        // get array of fieldnames in the primary key
        $pkeynames = $this->getPkeyNames();

        // now turn the array of columns into an array of rows
        $rowdata = array();
        $rownum = 0;
        //foreach ($updatearray as $fieldname => $fieldvalue) {
        foreach ($this->changes as $fieldname => $fieldvalue) {
            $rowdata[$rownum]['record_id']   = $this->record_id;
            $rowdata[$rownum]['field_id']    = $fieldname;
            $rowdata[$rownum]['field_value'] = $fieldvalue;
            // construct 'where' clause from primary key
            $where = array2where($rowdata[$rownum], $pkeynames, $this);

            // turn off all custom validation
            $this->skip_validation = true;

            // find out if this record currently exists or not
            $count = $this->getCount($where);
            if ($count == 0) {
                // record does not exist, so create it
                $rowdata[$rownum] = $this->insertRecord($rowdata[$rownum]);
            } else {
                // record already exists, so update it
                $rowdata[$rownum] = $this->updateRecord($rowdata[$rownum]);
            } // if

            if (!empty($this->errors)) {
                $this->fieldarray = $fieldarray;
                $this->fieldspec  = $this->changeConfig (null, $fieldarray);
                return;
            } // if
            $rownum = $rownum + 1;
        } // foreach

        $this->fieldarray      = $fieldarray;

        if (!empty($fieldarray['pagination_width'])) {
        	$_SESSION['pagination_width'] = $fieldarray['pagination_width'];
        } // if
        if (!empty($fieldarray['scrolling_width'])) {
        	$_SESSION['scrolling_width']  = $fieldarray['scrolling_width'];
        } // if

        return getLanguageText('sys0091');  // "Update successful"

    } // _cm_updateSelection

// ****************************************************************************
} // end class
// ****************************************************************************

?>
