<?php
    // file created on April 21, 2022, 4:24 pm
    // *****************************************************************************
    // $Date$
    // $Author$
    // $Revision$
    // *****************************************************************************

    // field specifications for table htm.orga_ausruestung
    $fieldspec['ausruestung_id']            = array('type' => 'string',
                                                    'size' => 50,
                                                    'pkey' => 'y',
                                                    'required' => 'y',
                                                    'uppercase' => 'y');
    
    $fieldspec['ausruestung_anr']           = array('type' => 'string',
                                                    'size' => 30,
                                                    'pkey' => 'y',
                                                    'required' => 'y');
    
    $fieldspec['rdcaccount_id']             = array('type' => 'integer',
                                                    'type_native' => 'int',
                                                    'size' => 10,
                                                    'minvalue' => 0,
                                                    'maxvalue' => 4294967295,
                                                    'pkey' => 'y',
                                                    'required' => 'y',
                                                    'default' => '1',
                                                    'noedit' => 'y',
                                                    'nosearch' => 'y');
    
    $fieldspec['ausruestung_marke']         = array('type' => 'string',
                                                    'size' => 20);
    
    $fieldspec['ausruestung_modell']        = array('type' => 'string',
                                                    'size' => 30);
    
    $fieldspec['ausruestung_desc']          = array('type' => 'string',
                                                    'size' => 255);
    
    $fieldspec['gr_art']                    = array('type' => 'string',
                                                    'size' => 20,
                                                    'control' => 'popup',
                                                    'task_id' => 'htm_orga_groessen_ausr(popup1)',
                                                    'foreign_field' => 'gr_art');
    
    $fieldspec['gr_art_sub']                = array('type' => 'string',
                                                    'size' => 20);
    
    $fieldspec['gr_art_rdc']                = array('type' => 'integer',
                                                    'type_native' => 'int',
                                                    'size' => 10,
                                                    'minvalue' => 0,
                                                    'maxvalue' => 4294967295);
    
    $fieldspec['ausruestung_farbe']         = array('type' => 'string',
                                                    'size' => 20);
    
    $fieldspec['ausruestung_farbnummer']    = array('type' => 'string',
                                                    'size' => 10);
    
    $fieldspec['ausruestung_preis_netto']   = array('type' => 'numeric',
                                                    'size' => 12,
                                                    'precision' => 11,
                                                    'scale' => 2,
                                                    'minvalue' => 0,
                                                    'maxvalue' => 999999999.99,
                                                    'default' => '0.00');
    
    $fieldspec['ausruestung_preis_rabatt']  = array('type' => 'numeric',
                                                    'size' => 7,
                                                    'precision' => 6,
                                                    'scale' => 3,
                                                    'minvalue' => 0,
                                                    'maxvalue' => 999.999,
                                                    'default' => '0.000');
    
    $fieldspec['ausruestung_preis_rabatt_berechnen']= array('type' => 'boolean',
                                                    'type_native' => 'tinyint',
                                                    'default' => '0',
                                                    'true' => '1',
                                                    'false' => '0',
                                                    'control' => 'checkbox');
    
    $fieldspec['ausruestung_preis_mwst']    = array('type' => 'numeric',
                                                    'size' => 12,
                                                    'precision' => 11,
                                                    'scale' => 2,
                                                    'minvalue' => 0,
                                                    'maxvalue' => 999999999.99,
                                                    'default' => '0.00');
    
    $fieldspec['ausruestung_preis_mwst_berechnen']= array('type' => 'boolean',
                                                    'type_native' => 'tinyint',
                                                    'default' => '1',
                                                    'true' => '1',
                                                    'false' => '0',
                                                    'control' => 'checkbox');
    
    $fieldspec['ausruestung_preis_brutto']  = array('type' => 'numeric',
                                                    'size' => 12,
                                                    'precision' => 11,
                                                    'scale' => 2,
                                                    'minvalue' => 0,
                                                    'maxvalue' => 999999999.99,
                                                    'default' => '0.00');
    
    $fieldspec['ausruestung_preis_eigenanteil']= array('type' => 'numeric',
                                                    'size' => 12,
                                                    'precision' => 11,
                                                    'scale' => 2,
                                                    'minvalue' => 0,
                                                    'maxvalue' => 999999999.99,
                                                    'default' => '0.00');
    
    $fieldspec['ausruestung_preis_berechnen']= array('type' => 'string',
                                                    'size' => 10,
                                                    'default' => '\'Brutto\'',
                                                    'control' => 'dropdown',
                                                    'optionlist' => 'brutto_netto_berechnen');
    
    $fieldspec['ausruestung_pfad_bild']     = array('type' => 'string',
                                                    'size' => 255);
    
    $fieldspec['ausruestung_pfad_video']    = array('type' => 'string',
                                                    'size' => 255);
    
    $fieldspec['ausruestung_barcode']       = array('type' => 'string',
                                                    'size' => 50);
    
    $fieldspec['node_id']                   = array('type' => 'integer',
                                                    'type_native' => 'int',
                                                    'size' => 5,
                                                    'minvalue' => 0,
                                                    'maxvalue' => 4294967295,
                                                    'default' => '0');
    
    $fieldspec['created_date']              = array('type' => 'datetime',
                                                    'size' => 20,
                                                    'required' => 'y',
                                                    'default' => '\'2014-01-01 00:00:00\'',
                                                    'autoinsert' => 'y',
                                                    'noedit' => 'y',
                                                    'nosearch' => 'y');
    
    $fieldspec['created_user']              = array('type' => 'string',
                                                    'size' => 16,
                                                    'required' => 'y',
                                                    'autoinsert' => 'y',
                                                    'noedit' => 'y',
                                                    'nosearch' => 'y');
    
    $fieldspec['revised_date']              = array('type' => 'datetime',
                                                    'size' => 20,
                                                    'autoupdate' => 'y',
                                                    'noedit' => 'y',
                                                    'nosearch' => 'y');
    
    $fieldspec['revised_user']              = array('type' => 'string',
                                                    'size' => 16,
                                                    'autoupdate' => 'y',
                                                    'noedit' => 'y',
                                                    'nosearch' => 'y');
    
    // primary key details 
    $this->primary_key                      = array('ausruestung_id',
                                                    'ausruestung_anr',
                                                    'rdcaccount_id');
    
    // unique key details 
    $this->unique_keys                      = array();
    
    // child relationship details 
    $this->child_relations[]                = array('child' => 'orga_kontakte_ausruestung',
                                                    'type' => 'RES',
                                                    'fields' => array('ausruestung_id' => 'ausruestung_id',
                                                                      'ausruestung_anr' => 'ausruestung_anr',
                                                                      'rdcaccount_id' => 'rdcaccount_id'));
    
    $this->child_relations[]                = array('child' => 'orga_mannschaften_ausruestung',
                                                    'type' => 'RES',
                                                    'fields' => array('ausruestung_id' => 'ausruestung_id',
                                                                      'ausruestung_anr' => 'ausruestung_anr',
                                                                      'rdcaccount_id' => 'rdcaccount_id'));
    
    $this->child_relations[]                = array('child' => 'orga_mannschaften_kontakte_ausruestung',
                                                    'type' => 'RES',
                                                    'fields' => array('ausruestung_id' => 'ausruestung_id',
                                                                      'ausruestung_anr' => 'ausruestung_anr',
                                                                      'rdcaccount_id' => 'rdcaccount_id'));
    
    // parent relationship details 
    $this->parent_relations[]               = array('parent' => 'orga_groessen_ausr',
                                                    'fields' => array('gr_art' => 'gr_art',
                                                                      'gr_art_sub' => 'gr_art_sub',
                                                                      'gr_art_rdc' => 'rdcaccount_id'));
    
    $this->parent_relations[]               = array('parent' => 'mnu_account',
                                                    'dbname' => 'menu',
                                                    'subsys_dir' => 'menu',
                                                    'fields' => array('rdcaccount_id' => 'rdcaccount_id'));
    
    // determines if database updates are recorded in an audit log 
    $this->audit_logging                    = TRUE;
    
    // default sort sequence 
    $this->default_orderby                  = '';
    
    // alternative language options 
    $this->alt_language_table               = '';
    $this->alt_language_cols                = '';
    
    // alias names 
    $this->nameof_start_date                = '';
    $this->nameof_end_date                  = '';
    
    // finished
?>