<?php
// *****************************************************************************
// Copyright 2003-2005 by A J Marston <http://www.tonymarston.net>
// Copyright 2006-2012 by Radicore Software Limited <http://www.radicore.org>
// *****************************************************************************
require_once 'std.table.class.inc';
class orga_ausruestung extends Default_Table
{
    // ****************************************************************************
    function __construct ()
    {
        // save directory name of current script
        $this->dirname   = dirname(__file__);

        $this->dbname      = 'htm';
        $this->tablename   = 'orga_ausruestung';

        // call this method to get original field specifications
        // (note that they may be modified at runtime)
        $this->fieldspec = $this->getFieldSpec_original();
        
    } // __construct
    
    // ****************************************************************************
    function _cm_formatData ($fieldarray, &$css_array)
    // perform custom formatting before values are shown to the user.
    // Note: $css_array is passed BY REFERENCE as it may be modified.
    {

        // customisable code goes here
        switch ($GLOBALS['mode']) {
            
            case 'search':
                break;
                
            case 'list':
                // justiert die Felder
                $css_array['gr_art'] = 'center';
                $css_array['gr_art_sub'] = 'center';
                $css_array['gr_art_rdc'] = 'center';
                $css_array['rdcaccount_id'] = 'center';
                
                //unset($this->fieldspec['mv_berechnung']['control']);
                // formatiert die Ausgabewerte
                //$array['mv_preis_netto'] = number_format($array['mv_preis_netto'], 2, '.', '.');
                
                break;

            case 'update':
                // setzt gr_art_sub in Nur-Lesen
                $this->fieldspec['gr_art_sub']['noedit'] = 'Y';
                
                break;
                
            case 'update':
                // setzt die Zahlenfelder auf 'rechtsbündig'
                // bei Update funktioniert das nicht! Das ganze Feld wird nach rechts gestellt.
                break;
                
            default:
                break;
                
        } // switch
        
        return $fieldarray;
        
    } // _cm_formatData
    
    // ****************************************************************************
    function _cm_getExtraData ($where, $fieldarray)
    // Perform custom processing for the getExtraData method.
    // $where = a string in SQL 'where' format.
    // $fieldarray = the contents of $where as an array.
    {

        // get values for groesse_international and insert into lookup array
//        $array = $this->getValRep('groesse_international');
//        $this->lookup_data['groesse_international'] = $array;

        // get values for brutto_netto_berechnen and insert into lookup array
        $array = $this->getValRep('brutto_netto_berechnen');
        $this->lookup_data['brutto_netto_berechnen'] = $array;
							
        return $fieldarray;

    } // _cm_getExtraData    
    
    // ****************************************************************************
    function _cm_getValRep ($item, $where, $orderby=null)
    // get Value/Representation list as an associative array.
    {
        $array = array();
        if ($item == 'brutto_netto_berechnen') {
            $array = getLanguageArray('brutto_netto_berechnen');
            return $array;
        } // if

        return $array;

    } // _cm_getValRep


    // ****************************************************************************
    function _cm_popupReturn ($fieldarray, $return_from, &$select_array, $return_files)
    {

        //	liest Daten in Abhängigkeit des aufrufenden Formulars ein
        switch ($return_from) {
            
            case  'htm_orga_groessen_ausr(popup1)' :
                
                // get contents of foreign table ORGA_GROESSEN_AUSR
                $dbobject =& RDCsingleton::getInstance('orga_groessen_ausr');	// Instanz für Lookup-Tabelle
 
                $where =    "gr_art='{$select_array['gr_art']}' AND " .
                            "gr_art_sub='{$select_array['gr_art_sub']}' AND " .
                            "rdcaccount_id='{$select_array['rdcaccount_id']}'";
                
                $data = $dbobject->getData ($where);
                
                if (!empty($data)){
                    $data = $data[0];
                    $fieldarray['ausruestungs_groesse_art_desc'] = $data['ausruestungs_groesse_art_desc'];
                    
                } // if
                                
                // löscht Wert von rdcaccount_id, weil dieser ansonsten in $fieldarray überschrieben wird
                //unset($select_array['rdcaccount_id']);

                break;
                
        }	// switch

        return $fieldarray;
        
    }
        
    // ****************************************************************************    
    function _cm_validateInsert ($rowdata)
    // perform custom validation before an insert.
    // if anything is placed in $this->errors the insert will be terminated.
    {
        // customisable code goes here
		// calculates Brutto- or Netto-Price
		if ($rowdata['ausruestung_preis_berechnen'] == 'Brutto') {

			if ($rowdata['ausruestung_preis_rabatt_berechnen'] == '1') {
				//	calculates Brutto-Price with Rabatt
				$p = $rowdata['ausruestung_preis_netto'] * (1-$rowdata['ausruestung_preis_rabatt']/100);
			}	// if
			elseif ($rowdata['ausruestung_preis_rabatt_berechnen'] == '0') {
				//	calculates Brutto-Price with Rabatt
				$p = $rowdata['ausruestung_preis_netto'];
			}	// elseif

			if ($rowdata['ausruestung_preis_mwst_berechnen'] == '1') {
				//	calculates MwSt-Price
				$p = $p * (1+$rowdata['ausruestung_preis_mwst']/100);
				}	// if

			//	actualizes $rowdata
			$rowdata['ausruestung_preis_brutto'] = $p;


		}	// if == 'Brutto'
		elseif ($rowdata['ausruestung_preis_berechnen'] == 'Netto') {

			if ($rowdata['ausruestung_preis_mwst_berechnen'] == '1') {
				//	calculates MwSt-Price
				$p = $rowdata['ausruestung_preis_brutto'] /(1+$rowdata['ausruestung_preis_mwst']/100);
			}	// if
			elseif ($rowdata['ausruestung_preis_mwst_berechnen'] == '0') {
				// calculates MwSt-Price
				$p = $rowdata['ausruestung_preis_brutto'];
			}

			if ($rowdata['ausruestung_preis_rabatt_berechnen'] == '1') {
				//	calculates Netto-Price with Rabatt
				$p = $p * (1-$rowdata['ausruestung_preis_rabatt']/100);
			}	// if

			//	actualizes $rowdata
			$rowdata['ausruestung_preis_netto'] = $p;

			
		}	// elseif == 'Netto'

        return $rowdata;

    } // _cm_validateInsert

    // ****************************************************************************
    function _cm_validateUpdate ($fieldarray, $originaldata)
    // perform custom validation before update.
    // if anything is placed in $this->errors the update will be terminated.
    {
        // customisable code goes here
		// calculates Brutto- or Netto-Price
		if ($fieldarray['ausruestung_preis_berechnen'] == 'Brutto') {

			if ($fieldarray['ausruestung_preis_rabatt_berechnen'] == '1') {
				//	calculates Brutto-Price with Rabatt
				$p = $fieldarray['ausruestung_preis_netto'] * (1-$fieldarray['ausruestung_preis_rabatt']/100);
			}	// if
			elseif ($fieldarray['ausruestung_preis_rabatt_berechnen'] == '0') {
				//	calculates Brutto-Price with Rabatt
				$p = $fieldarray['ausruestung_preis_netto'];
			}	// elseif

			if ($fieldarray['ausruestung_preis_mwst_berechnen'] == '1') {
				//	calculates MwSt-Price
				$p = $p * (1+$fieldarray['ausruestung_preis_mwst']/100);
				}	// if

			//	actualizes $rowdata
			$fieldarray['ausruestung_preis_brutto'] = $p;


		}	// if == 'Brutto'
		elseif ($fieldarray['ausruestung_preis_berechnen'] == 'Netto') {

			if ($fieldarray['ausruestung_preis_mwst_berechnen'] == '1') {
				//	calculates MwSt-Price
				$p = $fieldarray['ausruestung_preis_brutto'] /(1+$fieldarray['ausruestung_preis_mwst']/100);
			}	// if
			elseif ($fieldarray['ausruestung_preis_mwst_berechnen'] == '0') {
				// calculates MwSt-Price
				$p = $fieldarray['ausruestung_preis_brutto'];
			}

			if ($fieldarray['ausruestung_preis_rabatt_berechnen'] == '1') {
				//	calculates Netto-Price with Rabatt
				$p = $p * (1-$fieldarray['ausruestung_preis_rabatt']/100);
			}	// if

			//	actualizes $rowdata
			$fieldarray['ausruestung_preis_netto'] = $p;

			
		}	// elseif == 'Netto'
		

        return $fieldarray;

    } // _cm_validateUpdate


// ****************************************************************************
} // end class
// ****************************************************************************

?>
